#include "stm32f10x.h"
#include "I2CRoutines.h"
#include "DCM.h"
#include "math.h"
#include "Constrain.h"

#define ANGLE 50
#define ADC1_DR_Address    ((u32)0x4001244C)
#define AXCELSEN 0.333 //axcel sensitivity V/g
#define AXCELBIASX 1.653
#define AXCELBIASY 1.635
#define AXCELBIASZ 1.637//axcel zero g voltage V
#define ADCREF 3.313 //ADC ref. voltage(V)
#define GYROSEN 14.375 //gyro sensitivity LSB/(deg/s)
#define MAGSEN 1300 // mag sensitivity count/mgauss
#define ALTSEN 1024 //Altimeter sensitivit 1024 count/cm
#define PI 3.141593
#define MAGADDRESS 0x3C
#define GYROADDRESS 0xD2
#define ACCADDRESS 0x00
#define ORDER 5
#define ToRad(x) (x*0.01745329252)  // *pi/180
#define ToDeg(x) (x*57.2957795131)  // *180/pi
#define T .02
#define GRAVITY 2487
#define Accel_Scale(x) x/GRAVITY//Scaling the raw data of the accel to actual acceleration in meters for seconds square


// QuadCopter PID GAINS
float KP_QUAD_ROLL = 0.7;//0.85;
float KD_QUAD_ROLL = 2.1;//0.25;
float KI_QUAD_ROLL = 0.4;//0.5;
float KP_QUAD_PITCH = 0.85;//0.85;//0.9//0.4 //1.75 .3
float KD_QUAD_PITCH = 0.35;//0.25;//0.42//0.1 //0.2//0.45 .2
float KI_QUAD_PITCH = 2;//0.5;//0.5//0.01 //0.5
#define KP_QUAD_YAW 1.5 //2.6
#define KD_QUAD_YAW 0.4  //0.4
#define KI_QUAD_YAW 0.15   //0.15

uint16_t MTRVAL = 1000;
//Pitch Control
float err_pitch;
float pitch_I=0;
float pitch_D;
float pitchAngle;
float pitchAngleDeg;
int control_pitch;
float PreviousPosition_Pitch;

//Wifi Variables
uint8_t ntosr[14];
__IO uint8_t RxCounter =  0x00;
int pten;
uint8_t stat =0;
uint8_t sign = 0;
int temp1, temp2, temp3;
float dec;


//Roll Control
float roll_I=0;
float roll_D;
float error_roll;
float rollAngle;
float rollAngleDeg;
int control_roll;
float PreviousPosition_Roll;

//Yaw Control
float yaw_I=0;
float yaw_D;
float error_yaw;
float yawAngle;
int control_yaw;
float PreviousPosition_Yaw;

float MAG_X;
float MAG_Y;
float MAG_Heading;
float MAGheadingInit = 0;
float Heading_X;
float Heading_Y;
float MagTest;
float cos_roll;
float sin_roll;
float cos_pitch;
float sin_pitch;


//extern float Rmat[3][3];
extern float DCMt;
extern float roll;
extern float Omega[3];
extern float Accels[3];


//Declarations

void RCC_PeriphInit(void);
void GPIO_PeriphInit(void);
void TIM_PeriphInit(void);
void ADC_PeriphInit(void);
void UART_PeriphInit(void);
void I2C_PeriphInit(void);
void IMU_Read(void);//input I2C address of IMU device
void NVIC_Configuration(void);
void Delay(int count); //delay approx. (125 us * count)
void Motorcmd(int cmd);
void Wificom(void);
void attitudeControl(int iphonePitchCMD,int iphoneRollCMD,int iphoneYawCMD);
void CompassHeading(void);

//Wifi Functions
uint32_t SerialKeyPressed(uint8_t *key);
uint8_t GetKey(void);
void SerialPutChar(uint8_t c);
void Serial_PutString(uint8_t *s);
void ntos( float value, uint8_t* ntosr);

// VARIABLES

GPIO_InitTypeDef GPIO_InitStructure;
TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
TIM_OCInitTypeDef  TIM_OCInitStructure;
ADC_InitTypeDef ADC_InitStructure;
DMA_InitTypeDef DMA_InitStructure;
USART_InitTypeDef USART_InitStructure;

//IMU data variables
u8 IMUBuffer[6]; //temp IMU value storage
vs16 AccRead[4];
vs16 MagRead[3];
vs16 GyroRead[3]; //raw gyro data
vs16 GyroCrt[3];
float MagInt;
float COGtheta;
float AccCon[3];
float Altcon;
float MagCon[3];
float GyroCon[3]; //converted gyro data deg/sec
float GyroConTemp[3];
float Mtr1Start, Mtr2Start;
int Mtr1Val, Mtr2Val, Mtr3Val, Mtr4Val;
int iphonePitchCMD;
int iphoneRollCMD;
int iphoneYawCMD;
//double sqr[4] = {2,4,9,144};
//double root[4];
//configure IMU devices
u8 MAGconfig1[2] = {0x00, 0x18};
u8 MAGconfig2[2] = {0x01, 0x20};
u8 MAGconfig3[2] = {0x02, 0x00};
u8 GYROconfig1[2] = {0x3E, 0x80}; //reset gyro
u8 GYROconfig2[2] = {0x15, 0x13};
u8 GYROconfig3[2] = {0x16, 0x1E}; // set 8kHz sample rate, enable proper operation
u8 GYROconfig4[2] = {0x3E, 0x02}; //set x axis as pll source
u8 Gyrosr[1] = {0x1D}; //start register of gyro values
u8 Magsr[1] ={0x03};

uint8_t Buffer_Rx1[10];
/* Buffer of data to be transmitted by I2C1 */
uint8_t Buffer_Tx1[40];
/* Buffer of data to be received by I2C2 */

/* Buffer of data to be transmitted by I2C2 */
vu16 time[5] = {0,0,0,0,0};
int  i, j, k, x, y, z;
int start = 0, stop = 1, takeoff = 2, land = 3, Rx = 0, Tx = 1;
char flag = 'Y';
float B;

//Base Rotational Matrix
float Rmat[3][3] = {
		{1,0,0},
		{0,1,0},
		{0,0,1}
};

/************************************************************************
 * Function Name: main
 * Parameters: none
 * Return: Int32U
 *
 * Description: The main subroutine
 *
 *************************************************************************/


int main(void) {

	RCC_PeriphInit();
	GPIO_PeriphInit();
	NVIC_Configuration();
	TIM_PeriphInit();
	ADC_PeriphInit();
	UART_PeriphInit();
	I2C_PeriphInit();

	//Wifi function
	//USART_ITConfig(USART3, USART_IT_RXNE, ENABLE);

	//Accels[3] init
	IMU_Read();

	Accels[0] = AccCon[0];
	Accels[1] = AccCon[1];
	Accels[2] = AccCon[2];
	//Gyros[0] = GyroCon[0];
	//Gyros[1] = GyroCon[1];
	//Gyros[2] = GyroCon[2];

	//Mag_heading init
	CompassHeading();
	MAGheadingInit = MAG_Heading;

	z=0;
	//iphone test commands for the motors
	iphonePitchCMD = 0;
	iphoneRollCMD = 0;
	iphoneYawCMD = 0;


	//Motorcmd(start);
	Serial_PutString("\n\rReady\n\r");
	while(1) {

		while(TIM_GetFlagStatus(TIM1, TIM_FLAG_Update)==RESET);
		TIM1->SR = 0x0000; //clear update flag set by counter reset

		time[0] = TIM1->CNT;

		//Wifi function
		//USART_ITConfig(USART3, USART_IT_RXNE, DISABLE);



		IMU_Read(); // get and convert IMU data
		CompassHeading();
		Wificom();//wifi
		time[1] = TIM1->CNT; // total IMU read and conversion time

		updateRmat();
		correctRmat();

		//if(start){
			attitudeControl(iphonePitchCMD, iphoneRollCMD, iphoneYawCMD);
		//}


		//USART_ITConfig(USART3, USART_IT_RXNE, ENABLE);//wifi function

		time[2] = TIM1->CNT;





	}

}


//Functions definitions



void RCC_PeriphInit(void) {

	//RCC_USBCLKConfig(RCC_USBCLKSource_PLLCLK_1Div5);
	RCC_ADCCLKConfig(RCC_PCLK2_Div4);
	RCC_AHBPeriphClockCmd(RCC_AHBPeriph_DMA1, ENABLE);
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2 | RCC_APB1Periph_USART3 | RCC_APB1Periph_I2C1, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_TIM1 | RCC_APB2Periph_AFIO | RCC_APB2Periph_ADC1 | RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB, ENABLE);
	//RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC | RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB, ENABLE);
	//RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);
}

void GPIO_PeriphInit(void) {





	//ADC Pin config
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1 | GPIO_Pin_2 | GPIO_Pin_7;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
	GPIO_Init(GPIOA, &GPIO_InitStructure);
	//GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0 | GPIO_Pin_1;
	//GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;
	//GPIO_Init(GPIOB, &GPIO_InitStructure);


	//tim1 PWM pin config
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8 | GPIO_Pin_9 | GPIO_Pin_10 | GPIO_Pin_11;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOA, &GPIO_InitStructure);

	/* Configure USART3 RTS and USART2 Tx as alternate function push-pull */
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_14 | GPIO_Pin_10;
	GPIO_Init(GPIOB, &GPIO_InitStructure);

	/* Configure USART3 CTS and USART2 Rx as input floating */
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 | GPIO_Pin_11;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	GPIO_Init(GPIOB, &GPIO_InitStructure);


}

void TIM_PeriphInit(void) {

	u16 CCR1_Val = 1000; // 10% duty cycle
	u16 CCR2_Val = 1000; // 16.67% duty cycle
	u16 CCR3_Val = 1000; // 13.33% duty cycle
	u16 CCR4_Val = 1000; // 5% duty cycle
	u16 PrescalerValue = 0;

	//TIM2 used for delays
	TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1;
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
	TIM_TimeBaseStructure.TIM_Period = 2999; // set 8 kHz timer frequency cnt
	TIM_TimeBaseStructure.TIM_Prescaler = 2; //set 8 kHz timer frequency tim freq
	TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStructure);

	//TIM_ITConfig(TIM2, TIM_IT_Update, Enable);

	TIM_Cmd(TIM2, ENABLE);

	 /* -----------------------------------------------------------------------

		 - Prescaler = (TIM1CLK / TIM1 counter clock) - 1
		TIMCLK is set to 72 MHz

		 TIM1 Frequency = TIM1 counter clock/(ARR + 1); ARR = TIM_Period

		TIM1 Channel1 duty cycle = (TIM1_CCR1/ TIM1_ARR)* 100 = 50%
		TIM1 Channel2 duty cycle = (TIM1_CCR2/ TIM1_ARR)* 100 = 37.5%
		TIM1 Channel3 duty cycle = (TIM1_CCR3/ TIM1_ARR)* 100 = 25%
		TIM1 Channel4 duty cycle = (TIM1_CCR4/ TIM1_ARR)* 100 = 12.5% */
	 // -----------------------------------------------------------------------
	  // Compute the prescaler value
	  PrescalerValue = (uint16_t) (72000000 / 1000000) - 1; //counter clock set to 1000000 Hz
	  // Time base configuration
	  TIM_TimeBaseStructure.TIM_Period = 19999; //TIM frequency set to 50 Hz; 1000000/(19999+1) = 50
	  TIM_TimeBaseStructure.TIM_Prescaler = PrescalerValue;
	  TIM_TimeBaseStructure.TIM_ClockDivision = 0;
	  TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
	  TIM_TimeBaseStructure.TIM_RepetitionCounter = 0;

	  TIM_TimeBaseInit(TIM1, &TIM_TimeBaseStructure);

	  // PWM1 Mode configuration: Channel1
	  TIM_OCInitStructure.TIM_OCIdleState = TIM_OCIdleState_Set;
	  TIM_OCInitStructure.TIM_OCNIdleState = TIM_OCNIdleState_Reset;
	  TIM_OCInitStructure.TIM_OCNPolarity = TIM_OCNPolarity_Low;
	  TIM_OCInitStructure.TIM_OutputNState = TIM_OutputNState_Disable;
	  TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_PWM1;
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR1_Val;
	  TIM_OCInitStructure.TIM_OCPolarity = TIM_OCPolarity_High;

	  TIM_OC1Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC1PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel2
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR2_Val;

	  TIM_OC2Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC2PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel3
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR3_Val;

	  TIM_OC3Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC3PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  // PWM1 Mode configuration: Channel4
	  TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	  TIM_OCInitStructure.TIM_Pulse = CCR4_Val;

	  TIM_OC4Init(TIM1, &TIM_OCInitStructure);

	  TIM_OC4PreloadConfig(TIM1, TIM_OCPreload_Enable);

	  TIM_ARRPreloadConfig(TIM1, ENABLE);


	  // TIM1 enable counter
	  TIM_Cmd(TIM1, ENABLE);
	  TIM_CtrlPWMOutputs(TIM1, ENABLE); //enable output pins

}

void ADC_PeriphInit(void) {
	// ADC DMA configuration
	DMA_DeInit(DMA1_Channel1);
	DMA_InitStructure.DMA_PeripheralBaseAddr = (u32)ADC1_DR_Address;
	DMA_InitStructure.DMA_MemoryBaseAddr = (vu32)&AccRead;
	DMA_InitStructure.DMA_DIR = DMA_DIR_PeripheralSRC;
	DMA_InitStructure.DMA_BufferSize = 4;
	DMA_InitStructure.DMA_PeripheralInc = DMA_PeripheralInc_Disable;
	DMA_InitStructure.DMA_MemoryInc = DMA_MemoryInc_Enable;
	DMA_InitStructure.DMA_PeripheralDataSize = DMA_PeripheralDataSize_HalfWord;
	DMA_InitStructure.DMA_MemoryDataSize = DMA_MemoryDataSize_HalfWord;
	DMA_InitStructure.DMA_Mode = DMA_Mode_Circular;
	DMA_InitStructure.DMA_Priority = DMA_Priority_High;
	DMA_InitStructure.DMA_M2M = DMA_M2M_Disable;
	DMA_Init(DMA1_Channel1, &DMA_InitStructure);

	//DMA_ITConfig(DMA1_Channel1, DMA_IT_TC, ENABLE); //stop conversion while data is used

	// Enable DMA1 Channel1
	DMA_Cmd(DMA1_Channel1, ENABLE);

	// ADC1 configuration ------------------------------------------------------
	ADC_DeInit(ADC1);
	ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;
	ADC_InitStructure.ADC_ScanConvMode = ENABLE;
	ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;
	ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;
	ADC_InitStructure.ADC_NbrOfChannel = 4;
	ADC_Init(ADC1, &ADC_InitStructure);

	/* ADC1 regular channels configuration */
	ADC_RegularChannelConfig(ADC1, ADC_Channel_0 , 1, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_1, 2, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_2, 3, ADC_SampleTime_239Cycles5);
	ADC_RegularChannelConfig(ADC1, ADC_Channel_7, 4, ADC_SampleTime_239Cycles5);

	/* Enable ADC1 DMA */
	ADC_DMACmd(ADC1, ENABLE);

	/* Enable ADC1 */
	ADC_Cmd(ADC1, ENABLE);

	/* Enable ADC1 reset calibration register */
	ADC_ResetCalibration(ADC1);
	/* Check the end of ADC1 reset calibration register */
	while(ADC_GetResetCalibrationStatus(ADC1));

	/* Start ADC1 calibaration */
	ADC_StartCalibration(ADC1);
	/* Check the end of ADC1 calibration */
	while(ADC_GetCalibrationStatus(ADC1));

	/* Start ADC1 Software Conversion */
	ADC_SoftwareStartConvCmd(ADC1, ENABLE);
}

void I2C_PeriphInit(void) {

	I2C_LowLevel_Init(I2C1); //configure I2C
	Delay(160); // start up time delay for gyro 20 ms and mag 5ms
	I2C_Master_BufferWrite(I2C1, MAGconfig1, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, MAGconfig2, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, MAGconfig3, 2, Polling, 0x3C);
	I2C_Master_BufferWrite(I2C1, GYROconfig1,2,Polling, 0xD2); //write data to configure IMU
	I2C_Master_BufferWrite(I2C1, GYROconfig2,2,Polling, 0xD2);
	I2C_Master_BufferWrite(I2C1, GYROconfig3,2,Polling, 0xD2);
	I2C_Master_BufferWrite(I2C1, GYROconfig4,2,Polling, 0xD2);
	//Delay(160);
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		GyroCrt[x] = GyroRead[x];
	}
	Delay(4000);
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		GyroCrt[x] = GyroRead[x];
	}

}

void IMU_Read(void) {
	//ACCEL read and convert
	DMA_ClearFlag(DMA1_FLAG_TC1); //get next set of data
	while(!DMA_GetFlagStatus(DMA1_FLAG_TC1));  //wait for DMA data transfer to finish

	// convert analog value to g's
		AccCon[0] = ((float)AccRead[0]*ADCREF/4095-AXCELBIASX)/AXCELSEN;
		AccCon[1] = ((float)AccRead[1]*ADCREF/4095-AXCELBIASY)/AXCELSEN;
		AccCon[2] = ((float)AccRead[2]*ADCREF/4095-AXCELBIASZ)/AXCELSEN;// axcel g
		Altcon = (float)AccRead[3]/ALTSEN;
	//time[0] = TIM1->CNT; // ADC time
	//Mag. read and convert
	I2C_Master_BufferWrite(I2C1, Magsr,1,Polling, 0x3C);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0x3C);
	for(x=0; x<3; x++) {
		MagRead[x] = (IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1];
		MagCon[x] = (float)MagRead[x]/MAGSEN; //Mag field values in gauss
	}
	//time[2] = TIM1->CNT; //MAG time
	//Gyro read and convert
	I2C_Master_BufferWrite(I2C1, Gyrosr,1,Polling, 0xD2);
	I2C_Master_BufferRead(I2C1, IMUBuffer,6,DMA, 0xD2);
	for(x=0; x<3; x++) {
		GyroRead[x] = ((IMUBuffer[x*2]<<8) | IMUBuffer[x*2+1])-GyroCrt[x];
	//	if(GyroRead[x]*GyroRead[x]<64){
		//	GyroCon[x]=0;
	//	}
	//	else{
			GyroCon[x] = (float)GyroRead[x]*(PI/180)/GYROSEN; //Gyro values in rad/sec
	//	}
	}
	//time[1] = TIM1->CNT;

}

/**
  * @brief  Configures NVIC and Vector Table base location.
  * @param  None
  * @retval : None
  */

void Delay( int count) { // delays 125us for the amount set in the argument count (delay = 125us*count)
	//time = 0;
	//wait  125 us
	TIM2->EGR = 0x0001; // reset counter before starting
	TIM2->SR = (uint16_t)~TIM_FLAG_Update; //clear update flag set by counter reset
	while(count>0) { //continue until count is depleted
		while(TIM_GetFlagStatus(TIM2, TIM_FLAG_Update)==RESET); // wait until counter overflow at end of 125 us
		count--;
		TIM2->SR = 0x0000; //clear update flag caused by overflow
	}
}

void Motorcmd(int cmd) {
	if(cmd == start) {
		Delay(4000);
		TIM1->CCR1 = MTRVAL;
		Delay(4000);
		TIM1->CCR2 = MTRVAL;
		Delay(4000);
		TIM1->CCR3 = MTRVAL;
		Delay(4000);
		TIM1->CCR4 = MTRVAL;
	}
	else if(cmd == stop) {
		TIM1->CCR1 = 1000;
		TIM1->CCR2 = 1000;
		TIM1->CCR3 = 1000;
		TIM1->CCR4 = 1000;
	}
}

void attitudeControl(int iphonePitchCMD,int iphoneRollCMD,int iphoneYawCMD)
{
	// PITCH CONTROL: Motor 1
	pitchAngle = asinf(-Rmat[2][0]);
	pitchAngleDeg = ToDeg(pitchAngle);
	//PreviousPosition_Pitch = ToDeg(pitchAngle);
	err_pitch = iphonePitchCMD - ToDeg(pitchAngle);
	err_pitch = constrain(err_pitch,-30,30);

	pitch_I += err_pitch*T;
	pitch_I = constrain(pitch_I,-50,50);
	// To have a better (faster) response we can use the Gyro reading directly for the Derivative term...
	pitch_D = -ToDeg(Omega[1]);
	//pitch_D = ToDeg(pitchAngle) - PreviousPosition_Pitch;

	// PID control
	control_pitch = KP_QUAD_PITCH*err_pitch + KD_QUAD_PITCH*pitch_D + KI_QUAD_PITCH*pitch_I;

	// ROLL CONTROL
	rollAngle = atan2f(Rmat[2][1],Rmat[2][2]);
	rollAngleDeg = ToDeg(rollAngle);
	//PreviousPosition_Roll = ToDeg(rollAngle);

	error_roll = iphoneRollCMD - ToDeg(rollAngle);
	error_roll = constrain(error_roll,-30,30);

	roll_I += error_roll*T;
	roll_I = constrain(roll_I,-50,50);
	// To have a better (faster) response we can use the Gyro reading directly for the Derivative term...
	roll_D = -ToDeg(Omega[0]);
	//roll_D = ToDeg(rollAngle) - PreviousPosition_Roll;

	// PID control
	control_roll = KP_QUAD_ROLL*error_roll + KD_QUAD_ROLL*roll_D + KI_QUAD_ROLL*roll_I;

	// YAW CONTROL
	yawAngle = atan2f(Rmat[1][0],Rmat[0][0]);

	//PreviousPosition_Yaw = ToDeg(yawAngle);

	error_yaw = iphoneYawCMD - ToDeg(yawAngle);

	if (error_yaw > 180) // Normalize to -180,180
	{
		error_yaw -= 360;
	}
	else if(error_yaw < -180)
	{
		error_yaw += 360;
	}

	error_yaw = constrain(error_yaw,-60,60);

	yaw_I += error_yaw*T;
	yaw_I = constrain(yaw_I,-20,20);
	// To have a better (faster) response we can use the Gyro reading directly for the Derivative term...
	yaw_D = -ToDeg(Omega[2]);
	//yaw_D = ToDeg(yawAngle) - PreviousPosition_Yaw;

	// PID control
	control_yaw = KP_QUAD_YAW*error_yaw + KD_QUAD_YAW*yaw_D + KI_QUAD_YAW*yaw_I;

	/*TIM1->CCR1 = (vu16)Mtr1Val - control_pitch - control_yaw;
	TIM1->CCR2 = (vu16)Mtr2Val + control_pitch - control_yaw;
	TIM1->CCR3 = (vu16)Mtr3Val - control_roll + control_yaw;
	TIM1->CCR4 = (vu16)Mtr4Val + control_roll + control_yaw;*/
	//TIM1->CCR1 = constrain(1250 - control_pitch - control_yaw,1000,2000);
	//TIM1->CCR2 = constrain(1250 + control_pitch - control_yaw,1000,2000);
	//TIM1->CCR3 = constrain(1250 - control_roll + control_yaw,1000,2000);
	//TIM1->CCR4 = constrain(1250 + control_roll + control_yaw,1000,2000);
	//TIM1->CCR1 = constrain((vu16)MTRVAL - control_pitch - control_yaw + temp3,1000,2000);
	//TIM1->CCR2 = constrain((vu16)MTRVAL + control_pitch - control_yaw + temp3,1000,2000);
	//TIM1->CCR3 = constrain((vu16)MTRVAL - control_roll + control_yaw + temp3,1000,2000);
	//TIM1->CCR4 = constrain((vu16)MTRVAL + control_roll + control_yaw + temp3,1000,2000);
	// Quadcopter mix
	if ((temp3) > (MTRVAL+250))  // Minimun throttle to start control
		{
			TIM1->CCR1 = constrain((vu16)temp3 - control_pitch - control_yaw,1000,2000);// Right motor
			TIM1->CCR2 = constrain((vu16)temp3 + control_pitch - control_yaw,1000,2000);// Left motor
			TIM1->CCR3 = constrain((vu16)temp3 - control_roll + control_yaw,1000,2000);// Front motor
			TIM1->CCR4 = constrain((vu16)temp3 + control_roll + control_yaw,1000,2000);// Back motor
		}
	    else
	    {
	        roll_I = 0;  // reset I terms...
	        pitch_I = 0;
	        yaw_I = 0;
	        TIM1->CCR1 = constrain((vu16)MTRVAL,1000,2000);  // Motors stoped
	        TIM1->CCR2 = constrain((vu16)MTRVAL,1000,2000);
	        TIM1->CCR3 = constrain((vu16)MTRVAL,1000,2000);
	        TIM1->CCR4 = constrain((vu16)MTRVAL,1000,2000);
		}
}

void CompassHeading(void)
{
  cos_roll = cosf(rollAngle);
  sin_roll = sinf(rollAngle);
  cos_pitch = cosf(pitchAngle);
  sin_pitch = sinf(pitchAngle);
  // Tilt compensated Magnetic filed X:
  MAG_X = MagCon[0]*cos_pitch+MagCon[1]*sin_roll*sin_pitch+MagCon[2]*cos_roll*sin_pitch;
  // Tilt compensated Magnetic filed Y:
  MAG_Y = MagCon[1]*cos_roll-MagCon[2]*sin_roll;
  // Magnetic Heading
  MAG_Heading = atan2f(-MAG_Y,MAG_X) - MAGheadingInit;
  MagTest = ToDeg(MAG_Heading);
  Heading_X = cosf(MAG_Heading);
  Heading_Y = sinf(MAG_Heading);
}

void NVIC_Configuration(void)
{
	 NVIC_InitTypeDef NVIC_InitStructure;

	  /* Enable the USARTx Interrupt */
	  NVIC_InitStructure.NVIC_IRQChannel = USART3_IRQn;
	  NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
	  NVIC_InitStructure.NVIC_IRQChannelSubPriority = 0;
	  NVIC_InitStructure.NVIC_IRQChannelCmd = ENABLE;
	  NVIC_Init(&NVIC_InitStructure);


}



void UART_PeriphInit(void) {
	/* USART3 configuration ------------------------------------------------------*/

	  USART_InitStructure.USART_BaudRate = 115200;
	  USART_InitStructure.USART_WordLength = USART_WordLength_8b;
	  USART_InitStructure.USART_StopBits = USART_StopBits_1;
	  USART_InitStructure.USART_Parity = USART_Parity_No;
	  USART_InitStructure.USART_HardwareFlowControl = USART_HardwareFlowControl_None;
	  USART_InitStructure.USART_Mode = 0x000C;

	  USART_Init(USART3, &USART_InitStructure);
	  USART_ITConfig(USART3, USART_IT_RXNE, ENABLE);
	  /* Enable the USART3 */
	  USART_Cmd(USART3, ENABLE);

}

void Wificom(void) {
	if(start) {

		USART_ITConfig(USART3, USART_IT_RXNE, DISABLE);
			temp1 = (Buffer_Rx1[1]-'0')*10 + (Buffer_Rx1[2]-'0'); //R
			temp2 = (Buffer_Rx1[4]-'0')*10 + (Buffer_Rx1[5]-'0'); //L
			temp3 = ((Buffer_Rx1[7]-'0')*10 + (Buffer_Rx1[8]-'0'))*10+1000; //B
		USART_ITConfig(USART3, USART_IT_RXNE, ENABLE);
	}



		/*if(temp1 == 50 ) {
			iphoneYawCMD = (temp2-50);
		}
		else if(temp2 == 50) {
			iphoneYawCMD = (temp1-50);
		}
		else {*/
			iphonePitchCMD = temp1 - 50;
			iphoneRollCMD = temp2 - 50;
		//}



		if((Buffer_Rx1[RxCounter-1] == 'x') || (Buffer_Rx1[9] == 'X') ) { //kill quadcopter
					TIM1->CCR1 = 1000;
					TIM1->CCR2 = 1000;
					TIM1->CCR3 = 1000;
					TIM1->CCR4 = 1000;
					Serial_PutString("\n\rkilled\n\r");
					while(1) {

					}
			}
		if((Buffer_Rx1[9] == 'H') && (flag != 'H') ) { //stop motor
							flag = 'H';
							start = 0;
							TIM1->CCR1 = 1000;
							TIM1->CCR2 = 1000;
							TIM1->CCR3 = 1000;
							TIM1->CCR4 = 1000;

					}
		else if(Buffer_Rx1[RxCounter-1] == 'v'){
				Buffer_Rx1[RxCounter-1] = '\0';
				ntos(TIM1->CCR2, ntosr);
				Serial_PutString("\rValue = ");
				Serial_PutString(ntosr);
				Serial_PutString("\n\r");
			}
		else if(Buffer_Rx1[RxCounter-1] == 'a'){
					Buffer_Rx1[RxCounter-1] = '\0';
					RxCounter=0;
					iphoneRollCMD = -ANGLE;
					Serial_PutString("\r");
				}
		else if(Buffer_Rx1[RxCounter-1] == 'd'){
						Buffer_Rx1[RxCounter-1] = '\0';
						RxCounter=0;
						iphoneRollCMD = ANGLE;
						Serial_PutString("\r");
				}
		else if(Buffer_Rx1[RxCounter-1] == 'w'){
						Buffer_Rx1[RxCounter-1] = '\0';
						RxCounter=0;
						iphonePitchCMD = ANGLE;
						Serial_PutString("\r");
					}
		else if(Buffer_Rx1[RxCounter-1] == 's'){
						Buffer_Rx1[RxCounter-1] = '\0';
						RxCounter=0;
						iphonePitchCMD = -ANGLE;
						Serial_PutString("\r");
					}
		else if(Buffer_Rx1[RxCounter-1] == 'p'){
							Buffer_Rx1[RxCounter-1] = '\0';
							RxCounter=0;
							iphonePitchCMD = ANGLE;
							Serial_PutString("\r");
						}
		else if(Buffer_Rx1[RxCounter-1] == 'o'){
								Buffer_Rx1[RxCounter-1] = '\0';
								RxCounter=0;
								iphonePitchCMD = -ANGLE;
								Serial_PutString("\r");
							}
		else if((Buffer_Rx1[9] == 'S') && (flag != 'S')){
									//Buffer_Rx1[9] = 'Q';
									flag = 'S';
									//RxCounter=0;
									TIM1->CCR1 = MTRVAL;
									Delay(4000);
									TIM1->CCR2 = MTRVAL;
									Delay(4000);
									TIM1->CCR3 = MTRVAL;
									Delay(4000);
									TIM1->CCR4 = MTRVAL;
									start = 1;
									//Serial_PutString("\r");
								}

		//pid values
		else if(Buffer_Rx1[RxCounter-1] == '-'){
									Buffer_Rx1[RxCounter-1] = '\0';
									RxCounter=0;
									KP_QUAD_PITCH -= 0.05;
									ntos(KP_QUAD_PITCH, ntosr);
									Serial_PutString("\rP Value = ");
									Serial_PutString(ntosr);
									Serial_PutString("\n\r");
									Serial_PutString("\r");
								}
		else if(Buffer_Rx1[RxCounter-1] == '='){
										Buffer_Rx1[RxCounter-1] = '\0';
										RxCounter=0;
										KP_QUAD_PITCH += 0.05;
										ntos(KP_QUAD_PITCH, ntosr);
										Serial_PutString("\rP Value = ");
										Serial_PutString(ntosr);
										Serial_PutString("\n\r");
										Serial_PutString("\r");
									}
		else if(Buffer_Rx1[RxCounter-1] == '['){
										Buffer_Rx1[RxCounter-1] = '\0';
										RxCounter=0;
										KD_QUAD_PITCH -= 0.05;
										ntos(KD_QUAD_PITCH, ntosr);
										Serial_PutString("\rD Value = ");
										Serial_PutString(ntosr);
										Serial_PutString("\n\r");
										Serial_PutString("\r");
										Serial_PutString("\r");
									}
		else if(Buffer_Rx1[RxCounter-1] == ']'){
										Buffer_Rx1[RxCounter-1] = '\0';
										RxCounter=0;
										KD_QUAD_PITCH += 0.05;
										ntos(KD_QUAD_PITCH, ntosr);
										Serial_PutString("\rD Value = ");
										Serial_PutString(ntosr);
										Serial_PutString("\n\r");
										Serial_PutString("\r");
									}
		else if(Buffer_Rx1[RxCounter-1] == 'l'){
											Buffer_Rx1[RxCounter-1] = '\0';
											RxCounter=0;
											KI_QUAD_PITCH -= 0.05;
											ntos(KI_QUAD_PITCH, ntosr);
											Serial_PutString("\rI Value = ");
											Serial_PutString(ntosr);
											Serial_PutString("\n\r");
											Serial_PutString("\r");
										}
			else if(Buffer_Rx1[RxCounter-1] == ';'){
											Buffer_Rx1[RxCounter-1] = '\0';
											RxCounter=0;
											KI_QUAD_PITCH += 0.05;
											ntos(KI_QUAD_PITCH, ntosr);
											Serial_PutString("\rI Value = ");
											Serial_PutString(ntosr);
											Serial_PutString("\n\r");
											Serial_PutString("\r");
										}
		else if(Buffer_Rx1[RxCounter-1] == '\n') {
				Buffer_Rx1[RxCounter-1] = '\0';
				/*x=0;
				while(x<50) {
					if(Buffer_Rx1[x] == '1') {
						TIM1->CCR1 = ((uint16_t)Buffer_Rx1[x+1]-'0')*1000 + (uint16_t)(Buffer_Rx1[x+2]-'0')*100 + (uint16_t)(Buffer_Rx1[x+3]-'0')*10 + (uint16_t)(Buffer_Rx1[x+4]-'0');
					}
					if(Buffer_Rx1[x] == '2') {
						TIM1->CCR2 = ((uint16_t)Buffer_Rx1[x+1]-'0')*1000 + (uint16_t)(Buffer_Rx1[x+2]-'0')*100 + (uint16_t)(Buffer_Rx1[x+3]-'0')*10 + (uint16_t)(Buffer_Rx1[x+4]-'0');
					}
					if(Buffer_Rx1[x] == '3') {
						TIM1->CCR3 = ((uint16_t)Buffer_Rx1[x+1]-'0')*1000 + (uint16_t)(Buffer_Rx1[x+2]-'0')*100 + (uint16_t)(Buffer_Rx1[x+3]-'0')*10 + (uint16_t)(Buffer_Rx1[x+4]-'0');
					}
					if(Buffer_Rx1[x] == '4') {
						TIM1->CCR4 = ((uint16_t)Buffer_Rx1[x+1]-'0')*1000 + (uint16_t)(Buffer_Rx1[x+2]-'0')*100 + (uint16_t)(Buffer_Rx1[x+3]-'0')*10 + (uint16_t)(Buffer_Rx1[x+4]-'0');
					}
					x += 5;
				}*/
				RxCounter=0;
				Serial_PutString("cont.\n\r");
			}





}
uint32_t SerialKeyPressed(uint8_t *key)
{

	if ((USART3->SR & USART_FLAG_RXNE))

	  {
	    *key = (uint8_t)USART3->DR;
	    return 1;
	  }
	  else
	  {
	    return 0;
	  }
}

/**
  * @brief  Get a key from the HyperTerminal
  * @param  None
  * @retval The Key Pressed
  */
uint8_t GetKey(void)
{
  uint8_t key = 0;

  /* Waiting for user input */
  while (1)
  {
    if (SerialKeyPressed((uint8_t*)&key)) break;
  }
  return key;

}

void SerialPutChar(uint8_t c)
{

	USART3->DR = c;
	while (!(USART3->SR & USART_FLAG_TXE))
	{

	}

}

void Serial_PutString(uint8_t *s)
{
  while (*s != '\0')
  {
    SerialPutChar(*s);

    s++;
  }
}

void ntos( float value, uint8_t* ntosr) { //convert number to string

	for(x=0;x<14;x++){
		ntosr[x] = '/0';
	}
	x = 0;
	sign = 0;
	stat = 0;
	temp1 = value;
	dec = value - temp1;
	temp2 = dec*1000000;

    if(temp1<0) {
		ntosr[0] = '-';
		x++;
		sign++;
		temp1 *= -1;
		temp2 *= -1;
	}

    if(temp1 > 0) {
        pten = 100000;
    	while((x<8) && (pten>0)) {

    		ntosr[x++] = (uint8_t)(temp1/pten + '0');
    		temp1 = temp1 % pten;
    		pten /= 10;

    		if ((ntosr[x-1] == '0') & (stat == 0))
        		{
         			 x = sign;
        		}
        		else
        		{
          			stat++;
        		}


    	}
    	temp1 = 1;
    }
   	else {
         ntosr[x++] = '0';
         stat++;
    }
	if(temp2 > 0) {
        ntosr[x++] = '.';
    	pten = 100000;
    	stat = x;
    	while((x<(stat+6)) && (x<14) && (pten>0)) {
    		ntosr[x++] = (uint8_t)(temp2/pten + '0');
    		temp2 = temp2 % pten;
    		pten /= 10;
    	}
     }


}




